@extends($activeTemplate.'layouts.frontend')
@section('content')
<section class="pricing-plan section-bg py-80">
    <div class="container">
        <div class="row gy-4 justify-content-center position-relative">
            @foreach ($plans as $item)
            <div class="col-lg-4 col-md-6">
                <div class="pricing-plan-item">
                    <div class="price-shape-2"></div>
                    <div class="pricing-plan-item__top">
                        <h3 class="title">{{__($item->name)}}</h3>
                    </div>
                    <div class="pricing-plan-item__price">
                        <h3 class="title">{{__($general->cur_sym)}} {{showAmount($item->price)}}<span>{{$item->type==1 ? '/m' : '/y'}}</span></h3>
                    </div>
                    <div class="pricing-plan-item__list">
                        <ul>
                            <li> <i class="fas fa-check-circle"></i>@lang('Product Affiliate Commision') {{$item->ref_com}}%</li>
                            @if(@$item->content)
                            @foreach(json_decode(@$item->content) as $value)
                            <li> <i class="fas fa-check-circle"></i>{{$value}}</li>
                            @endforeach
                            @endif
                        </ul>
                    </div>
                    <div class="pricing-plan-item__bottom">
                        <a class="btn btn--base" href="{{route('user.payment',$item->id)}}">
                           @lang('Get Started') <i class="fas fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        <div class="row mt-4">
            @if ($plans->hasPages())
            <div class="col-md-12 d-flex justify-content-end">
                {{ paginateLinks($plans) }}
            </div>
            @endif
        </div>
    </div>
</section>
@endsection
