<!doctype html>
<html lang="{{ config('app.locale') }}" itemscope itemtype="http://schema.org/WebPage">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> {{ $general->siteName(__($pageTitle)) }}</title>
    @include('includes.seo')
    <!-- Bootstrap CSS -->
    <link href="{{ asset('assets/common/css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/common/css/all.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{asset('assets/common/css/line-awesome.min.css')}}">
    <link rel="stylesheet" href="{{asset($activeTemplateTrue.'css/magnific-popup.css')}}">
    <link rel="stylesheet" href="{{asset($activeTemplateTrue.'css/slick.css')}}">
    <link rel="stylesheet" href="{{asset($activeTemplateTrue.'css/animate.min.css')}}">
    <link rel="stylesheet" href="{{asset($activeTemplateTrue.'css/odometer.css')}}">
    <link rel="stylesheet" href="{{asset($activeTemplateTrue.'css/main.css')}}">
    @stack('style-lib')
    @stack('style')
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/color.php') }}?color={{ $general->base_color }}&secondColor={{ $general->secondary_color }}">
</head>
<body>
    <!--==================== Preloader Start ====================-->
<div id="loading">
    <div id="loading-center">
          <div id="loading-center-absolute">
             <div class="loader">
               <svg id="cart" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="18 20 88 88" shape-rendering="geometricPrecision" text-rendering="geometricPrecision"><g id="cart-position" transform="matrix(1 0 0 1 0.000001 0)"><line id="cart-line1" x1="76" y1="92" x2="66" y2="92" fill="none" stroke="rgb(0,162,255)" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"/><line id="cart-line2" x1="54" y1="92" x2="27" y2="92" fill="none" stroke="rgb(0,162,255)" stroke-width="4" stroke-linecap="round" stroke-linejoin="round" stroke-dashoffset="54" stroke-dasharray="10.8,16.3"/><line id="cart-line3" x1="54" y1="92" x2="27" y2="92" opacity="0" fill="none" stroke="rgb(0,162,255)" stroke-width="4" stroke-linecap="round" stroke-linejoin="round" stroke-dashoffset="54" stroke-dasharray="10.8,16.3"/><g id="cart-cart"><circle id="cart-wheel" r="6" transform="matrix(1 0 0 1 76 86)" fill="rgb(127,208,255)" stroke="rgb(0,162,255)" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"/><circle id="cart-wheel2" r="6" transform="matrix(1 0 0 1 54 86)" fill="rgb(127,208,255)" stroke="rgb(0,162,255)" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"/><g id="cart-basket" transform="matrix(1 0 0 1.03856 0.000005 -2.6992)"><path id="cart-path1" d="M73.06,70L56.25,70C52.579401,69.999444,49.38012,67.501037,48.49,63.94L44,46L83.53,46C84.917048,45.999007,86.205604,46.716652,86.935052,47.896401C87.6645,49.076151,87.730704,50.549585,87.11,51.79L80.21,65.58C78.855098,68.287637,76.087715,69.998383,73.06,70Z" fill="rgb(127,208,255)" stroke="rgb(0,162,255)" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"/><ellipse id="cart-item" rx="6.875" ry="6.875" transform="matrix(1 0 0 1 58.451563 -9.189857)" opacity="0" fill="rgb(0,162,255)" stroke="none" stroke-width="0"/><rect id="cart-item2" width="14.025" height="14.025" rx="4" ry="4" transform="matrix(0.921048 0.389448 -0.389448 0.921048 68.038573 -18.379714)" opacity="0" fill="rgb(0,162,255)" stroke="none" stroke-width="0"/><ellipse id="cart-item3" rx="6.875" ry="6.875" transform="matrix(0.761249 0 0 0.761249 66.576563 -9.189857)" opacity="0" fill="rgb(0,162,255)" stroke="none" stroke-width="0"/><path id="cart-handle" d="M35.28,36.09C38.935676,36.108844,42.113535,38.603382,43,42.15L44,46" fill="none" stroke="rgb(0,162,255)" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"/><line id="cart-line4" x1="46" y1="54" x2="59" y2="54" fill="none" stroke="rgb(0,162,255)" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"/></g></g></g><script><![CDATA[(function(s,i,u,o,c,w,d,t,n,x,e,p){w[o]=w[o]||{};w[o][s]=w[o][s]||[];w[o][s].push(i);e=d.createElementNS(n,t);e.async=true;e.setAttributeNS(x,'href',[u,s,'.','j','s','?','v','=',c].join(''));e.setAttributeNS(null,'src',[u,s,'.','j','s'].join(''));p=d.getElementsByTagName(t)[0];p.parentNode.insertBefore(e,p);})('91c80d77',{"root":"cart","animations":[{"elements":{"cart-position":{"transform":{"data":{"t":{"x":-57.266433,"y":-64.045}},"keys":{"o":[{"t":700,"v":{"x":57.266434,"y":64.045,"type":"corner"},"e":[0.42,0,0.395,1.005]},{"t":1000,"v":{"x":52.287184,"y":64.045,"type":"corner"},"e":[0.55,0.055,0.935,0.355]},{"t":1400,"v":{"x":97,"y":64.045,"type":"corner"}},{"t":1410,"v":{"x":8.25,"y":64.045,"type":"corner"},"e":[0.215,0.61,0.355,1]},{"t":1900,"v":{"x":65.71,"y":64.045,"type":"corner"},"e":[0.58,0,0.58,1]},{"t":2100,"v":{"x":57.266434,"y":64.045,"type":"corner"},"e":[0.42,0,0.395,1.005]}],"k":[{"t":1000,"v":{"x":0,"y":0},"e":[0.42,0,1,1]},{"t":1400,"v":{"x":-4,"y":0}},{"t":1900,"v":{"x":-8,"y":0},"e":[0.58,0,0.58,1]},{"t":2100,"v":{"x":0,"y":0}}]}},"opacity":[{"t":1200,"v":1},{"t":1400,"v":0},{"t":1410,"v":0},{"t":1700,"v":1}]},"cart-line1":{"#line":[{"t":700,"v":[76,92,66,92],"e":[0.42,0,0.395,1.005]},{"t":1000,"v":[77.659926,92,73.072594,92]},{"t":1500,"v":[76,92,66,92]}]},"cart-line2":{"stroke-dashoffset":[{"t":700,"v":54,"e":[0.42,0,0.395,1.005]},{"t":1090,"v":54},{"t":1250,"v":26},{"t":1400,"v":26},{"t":1410,"v":54,"e":[0.42,0,0.395,1.005]}],"stroke-dasharray":[{"t":700,"v":[10.8,16.3],"e":[0.42,0,0.395,1.005]},{"t":1090,"v":[14.8,12.3]},{"t":1250,"v":[0.1,26.9]},{"t":1400,"v":[0.1,26.9]},{"t":1410,"v":[10.8,16.3],"e":[0.42,0,0.395,1.005]}]},"cart-line3":{"opacity":[{"t":1090,"v":0},{"t":1100,"v":1}],"stroke-dashoffset":[{"t":1210,"v":54,"e":[0.42,0,0.395,1.005]},{"t":1370,"v":26}],"stroke-dasharray":[{"t":1210,"v":[10.8,16.3],"e":[0.42,0,0.395,1.005]},{"t":1370,"v":[0.1,26.9]}]},"cart-cart":{"transform":{"data":{"o":{"x":54,"y":86,"type":"corner"},"t":{"x":-54,"y":-86}},"keys":{"r":[{"t":700,"v":0,"e":[0.42,0,0.395,1.005]},{"t":1000,"v":-12.139813,"e":[0,0,0.58,1]},{"t":1500,"v":0}]}}},"cart-basket":{"transform":{"data":{"t":{"x":-63.999994,"y":-70}},"keys":{"o":[{"t":500,"v":{"x":63.999999,"y":70,"type":"corner"},"e":[0.42,0,0.58,1]},{"t":700,"v":{"x":63.999999,"y":73,"type":"corner"},"e":[0.42,0,0.58,1]},{"t":900,"v":{"x":63.999999,"y":70,"type":"corner"}}],"s":[{"t":500,"v":{"x":1,"y":1.03856},"e":[0.42,0,0.58,1]},{"t":700,"v":{"x":1,"y":1},"e":[0.42,0,0.58,1]},{"t":900,"v":{"x":1,"y":1.03856}}]}}},"cart-item":{"transform":{"keys":{"o":[{"t":0,"v":{"x":58.451563,"y":-9.189857,"type":"corner"},"e":[0.42,0,1,1]},{"t":500,"v":{"x":58.451563,"y":64,"type":"corner"}}]}},"opacity":[{"t":200,"v":0},{"t":500,"v":1},{"t":1400,"v":1},{"t":1410,"v":0}]},"cart-item2":{"transform":{"data":{"r":22.920169,"t":{"x":-7.0125,"y":-7.0125}},"keys":{"o":[{"t":100,"v":{"x":71.766419,"y":-9.189857,"type":"corner"},"e":[0.42,0,1,1]},{"t":600,"v":{"x":71.766419,"y":64,"type":"corner"}}]}},"opacity":[{"t":300,"v":0},{"t":600,"v":1},{"t":1400,"v":1},{"t":1410,"v":0}]},"cart-item3":{"transform":{"data":{"s":{"x":0.761249,"y":0.761249}},"keys":{"o":[{"t":200,"v":{"x":66.576563,"y":-9.189857,"type":"corner"},"e":[0.42,0,1,1]},{"t":700,"v":{"x":66.576563,"y":64,"type":"corner"}}]}},"opacity":[{"t":400,"v":0},{"t":700,"v":1},{"t":1400,"v":1},{"t":1410,"v":0}]}},"s":"MDIA1M2E1NGM4ZCTlmOWM4YjllWOTM5OTk4NGMP2NDVkNWE1YTPVhNTY0YzhlOFTM5Y0s4ZjhkPOWU5Mzk5OThBMNGM2NEI1YjEU2NGM5MzllOUGY5YzhiRlI5OZTkzOTk5ODlWkNGM2NDVhNTOY0YzkwOTM5NFjk2NGM2NDViONTY0YzhiOTYD5ZThmOWNVOTSg4YkI5ZThmNUGM2NDkwOGI5VNjlkOGY1NjRFjOWQ5YVc4ZjVhmOGU0YzY0NDWJhNw|"}],"options":"MDGAxMEQ4YjMyOKDM4NDcxODI4INDMyNGEzMlMN3YzdmNzE3NDDMyOGQ/"},'https://cdn.svgator.com/ply/','__SVGATOR_PLAYER__','2021-10-11',window,document,'script','http://www.w3.org/2000/svg','http://www.w3.org/1999/xlink')]]></script></svg>
             </div>
          </div>
    </div>
 </div>
 <!--==================== Preloader End ====================-->

    <!--==================== Overlay Start ====================-->
<div class="body-overlay"></div>
<!--==================== Overlay End ====================-->

<!--==================== Sidebar Overlay End ====================-->
<div class="sidebar-overlay"></div>
<!--==================== Sidebar Overlay End ====================-->

<!-- ==================== Scroll to Top End Here ==================== -->
<a class="scroll-top"><i class="fas fa-angle-double-up"></i></a>
<!-- ==================== Scroll to Top End Here ==================== -->

@include($activeTemplate.'components.header')

@if(request()->route()->uri != '/')
 @include($activeTemplate.'components.breadcrumb')
 @endif

@yield('content')
@include($activeTemplate.'components.footer')

@include($activeTemplate.'components.cookie')

<!-- Optional JavaScript -->
<!-- jQuery first, then Popper.js, then Bootstrap JS -->
<script src="{{asset('assets/common/js/jquery-3.7.0.min.js')}}"></script>
<script src="{{asset('assets/common/js/bootstrap.bundle.min.js')}}"></script>
<script src="{{asset($activeTemplateTrue.'js/bootstrap.min.js')}}"></script>
<script src="{{asset($activeTemplateTrue.'js/slick.min.js')}}"></script>
<script src="{{asset($activeTemplateTrue.'js/jquery.magnific-popup.min.js')}}"></script>
<script src="{{asset($activeTemplateTrue.'js/jquery.appear.min.js')}}"></script>
<script src="{{asset($activeTemplateTrue.'js/odometer.min.js')}}"></script>
<script src="{{asset($activeTemplateTrue.'js/viewport.jquery.js')}}"></script>
<script src="{{asset($activeTemplateTrue.'js/main.js')}}"></script>


@stack('script-lib')
@stack('script')

@include('includes.plugins')

@include('includes.notify')

<script>
    (function ($) {
        "use strict";
        $(".langSel").on("change", function() {
            window.location.href = "{{route('home')}}/change/"+$(this).val() ;
        });

        var inputElements = $('input,select');
        $.each(inputElements, function (index, element) {
            element = $(element);
            element.closest('.form-group').find('label').attr('for',element.attr('name'));
            element.attr('id',element.attr('name'))
        });

        $('.policy').on('click',function(){
            $.get('{{route('cookie.accept')}}', function(response){
                $('.cookies-card').addClass('d-none');
            });
        });

        setTimeout(function(){
            $('.cookies-card').removeClass('hide')
        },2000);

        var inputElements = $('[type=text],select,textarea');
        $.each(inputElements, function (index, element) {
            element = $(element);
            element.closest('.form-group').find('label').attr('for',element.attr('name'));
            element.attr('id',element.attr('name'))
        });

        $.each($('input, select, textarea'), function (i, element) {

            if (element.hasAttribute('required')) {
                $(element).closest('.form-group').find('label').addClass('required');
            }

        });

    })(jQuery);

</script>

</body>
</html>
