@php
$contact = getContent('contact_us.content',true);
$socialIcons = getContent('social_icon.element',false);
$languages = App\Models\Language::all();
$pages = App\Models\Page::where('tempname',$activeTemplate)->get();
$wishlistCount = App\Models\Wishlist::where('user_id',@auth()->user()->id)->count();
@endphp
<!--========================== Header section Start ==========================-->
<div class="header-main-area">
    <div class="header-top">
        <div class="container">
            <div class="top-header-wrapper">
                <div class="top-contact">
                    <ul class="login-registration-list d-flex flex-wrap justify-content-between align-items-center">
                        <li class="login-registration-list__item">
                            <ul class="social-list">
                                @foreach($socialIcons as $item)
                                <li class="social-list__item"><a href="{{ __($item->data_values->url)}}" class="social-list__link" target="_blank">@php echo $item->data_values->social_icon @endphp</a> </li>
                                @endforeach
                            </ul>
                        </li>
                    </ul>
                </div>
                <div class="top-button">
                    <div class="language-box me-2">
                        <select class="langSel select">
                            @foreach($languages as $language)
                            <option value="{{ $language->code }}" @if(Session::get('lang')===$language->code)
                                selected @endif>{{ __($language->name) }}</option>
                            @endforeach
                        </select>
                    </div>

                    <ul class="contact-list">
                        <li class="contact-list__item"> <span class="contact-list__item-icon"><i class="fas fa-phone"></i></span><a href="tel:{{$contact->data_values->contact_number}}" class="contact-list__link">{{__($contact->data_values->contact_number)}}</a></li>
                        <li class="contact-list__item"> <span class="contact-list__item-icon"><i class="fas fa-envelope"></i></span><a href="mailto:{{$contact->data_values->email_address}}" class="contact-list__link">{{__($contact->data_values->email_address)}}</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="header" id="header">
        <div class="container position-relative">
            <div class="row">
                <div class="header-wrapper">
                    <div class="header-menu-wrapper align-items-center d-flex">
                        <div class="logo-wrapper">
                            <a href="{{route('home')}}" class="normal-logo"> <img src="{{ getImage(getFilePath('logoIcon').'/logo.png', '?'
                                .time()) }}" alt="{{config('app.name')}}"></a>

                            <a href="{{route('home')}}" class="dark-logo hidden"  > <img src="{{ getImage(getFilePath('logoIcon').'/logo_white.png', '?'
                                    .time()) }}" alt="{{config('app.name')}}"></a>
                        </div>
                    </div>


                    <div class="menu-wrapper">
                        <ul class="main-menu">
                            @auth
                            <li>
                                <a class="{{ Route::is('user.home') ? 'active' : '' }}" aria-current="page" href="{{route('user.home')}}">@lang('Dashboard')</a>
                            </li>
                            @endauth
                            @foreach($pages as $page)
                            <li><a class="{{ Request::url() == url('/').'/'.$page->slug ? 'active' : '' }}" aria-current="page" href="{{route('pages',[$page->slug])}}">{{__($page->name)}}</a>
                            @endforeach
                            @auth
                            <li><a href="{{route('user.logout')}}"><i class="fas fa-sign-out-alt"></i> @lang('Logout')</a></li>

                            @else
                            <li><a class="{{ Route::is('user.login') ? 'active' : '' }}" href="{{route('user.login')}}"><i class="fas fa-sign-in-alt"></i> @lang('Login')</a></li>
                            @endauth

                            <li class="position-relative">
                                <div class="menu-search-wrap">
                                    <div class="menu-search-wrap--search-icon">
                                        <i class="fas fa-search header-search-icon"></i>
                                        <i class="fas fa-times close-hide-show"></i>
                                    </div>

                                    <div class="search-box header-search header-search-hide-show">
                                        <input type="text" class="form--control searchProduct" placeholder="Search...">
                                        <button type="submit" class="search-box__button"><i class="fas fa-search"></i></button>
                                    </div>
                                </div>
                                <div class="search-result-wrap d-none">
                                    <ul>
                                        <li class="search-results searchResults"></li>
                                    </ul>
                                </div>
                            </li>
                        </ul>
                    </div>

                    <div class="menu-right-wrapper">
                        <ul>
                            <li>
                                <div class="light-dark-btn-wrap ms-1" id="light-dark-checkbox">
                                    <i class="fas fa-moon mon-icon"></i>
                                    <i class='fas fa-sun sun-icon'></i>
                                </div>
                            </li>
                            <li class='shopping-cart position-relative'>
                                <a  href="{{route('get.cart')}}">
                                    <i class="fas fa-shopping-cart"></i>
                                    <span class="count-item" id="cartItem">{{ count((array) session('cart')) }}</span>
                                </a>
                            </li>
                            <li class='shopping-cart position-relative'>
                                <a  href="{{route('user.get.wishlist')}}">
                                    <i class="fas fa-heart"></i>
                                    <span class="count-item" id="wishlistItem">{{__($wishlistCount)}}</span>
                                </a>
                            </li>
                            <li><i class="fas fa-bars sidebar-menu-show-hide"></i></li>

                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--========================== Header section End ==========================-->


 <!--========================== Sidebar mobile menu wrap Start ==========================-->
<div class="sidebar-menu-wrapper">
    <div class="top-close d-flex align-items-center justify-content-between">
        <div class="header-wrapper">
            <div class="logo-wrapper mb-3">
                <div class="logo-wrapper">
                    <a href="{{route('home')}}" class="normal-logo"> <img src="{{ getImage(getFilePath('logoIcon').'/logo.png', '?'
                        .time()) }}" alt="{{config('app.name')}}"></a>
                    <a href="{{route('home')}}" class="dark-logo hidden" > <img src="{{ getImage(getFilePath('logoIcon').'/logo_white.png', '?'
                        .time()) }}" alt="{{config('app.name')}}"></a>
                </div>
            </div>
        </div>
        <i class="fas fa-times close-hide-show"></i>
    </div>
    <ul class="sidebar-menu-list">
        @auth
        <li class="sidebar-menu-list__item {{ Route::is('user.home') ? 'active' : '' }}">
            <a href="{{route('user.home')}}" class="sidebar-menu-list__link">@lang('Dashboard')</a>
        </li>
        @endauth
        @foreach($pages as $page)
        <li class="sidebar-menu-list__item {{ Request::url() == url('/').'/'.$page->slug ? 'active' : '' }}">
            <a href="{{route('pages',[$page->slug])}}" class="sidebar-menu-list__link"> {{__($page->name)}}</a>
        </li>
        @endforeach
        @auth
        <li class="sidebar-menu-list__item">
            <a href="{{route('user.logout')}}" class="sidebar-menu-list__link">@lang('Logout')</a>
        </li>
        @else
        <li class="sidebar-menu-list__item {{ Route::is('user.login') ? 'active' : '' }}">
            <a href="{{route('user.login')}}" class="sidebar-menu-list__link">@lang('Login')</a>
        </li>
        @endauth

        <li class="sidebar-menu-list__item">
            <div class="search-box header-search">
                <input type="text" class="form--control searchProduct" placeholder="Search...">
                <button type="submit" class="search-box__button"><i class="fas fa-search"></i></button>
            </div>

            <div id="mobile-menu">
                <div class="search-result-wrap mobile-search d-none">
                    <ul>
                        <li class="search-results searchResults"></li>
                    </ul>
                </div>
            </div>
        </li>
    </ul>
</div>
<!--========================== Sidebar mobile menu wrap End ==========================-->


@push('script')
    <script>
        $(document).ready(function() {
            $('.searchProduct').on('keyup', function() {
                var baseUrl = '{{ url('/') }}';
                var searchValue = $(this).val().trim();
                var searchResults = $(this).closest('.position-relative').find('.search-results');
                var searchResultsMobileMenu = $('#mobile-menu .search-result-wrap .search-results');

                if (searchValue !== '') {
                    $.ajax({
                        url: '{{ route("product.search") }}',
                        type: 'get',
                        data: { search: searchValue },
                        dataType: 'json',
                        success: function(response) {
                            searchResults.empty();
                            searchResultsMobileMenu.empty();

                            $('.search-result-wrap').removeClass('d-none')

                            if (response.length > 0) {
                                $.each(response, function(index, product) {
                                    var productName = product.name;
                                    var productSlug = slugify(productName);
                                    var productId = product.id;

                                    var productLink = baseUrl + '/product/' + productSlug + '/' + productId;

                                    var resultItem = $('<a>' + productName + '</a>');
                                    resultItem.attr('href', productLink);
                                    // resultItem.css('opacity', 0);
                                    searchResults.append(resultItem);
                                    searchResultsMobileMenu.append(resultItem.clone()); // Append to mobile menu search results
                                    resultItem.animate({ opacity: 1, marginLeft: '10px' }, 500);
                                });
                                searchResults.show();
                            } else {
                                searchResults.html('<p>No results found.</p>');
                                searchResultsMobileMenu.html('<p>No results found.</p>');
                            }
                        }.bind(this)
                    });
                } else {
                    searchResults.empty();
                    searchResultsMobileMenu.empty();
                    $('.search-result-wrap').addClass('d-none');
                }
            });

            $('.close-hide-show').on('click', function() {
                var searchResults = $(this).closest('.position-relative').find('.search-results');
                var searchInput = $(this).closest('.position-relative').find('.searchProduct');
                searchInput.val('');
                searchResults.empty();
            });

            function slugify(text) {
                return text.toString().toLowerCase()
                    .replace(/\s+/g, '-')
                    .replace(/[^\w\-]+/g, '')
                    .replace(/\-\-+/g, '-')
                    .replace(/^-+/, '')
                    .replace(/-+$/, '');
            }
        });
    </script>
@endpush
